*This do file removes the non-necessary information before creating the MATLAB dataset for ML estimation
use mle_data.dta, clear

gen cumtd3 = totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2
gen cumtd6 = totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2 + totday3 + totday4  + totday5
gen cumtd9 = totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2 + totday3 + totday4  + totday5 + totday6 + totday7  + totday8
gen cumtd12= totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2 + totday3 + totday4  + totday5 + totday6 + totday7  + totday8 + totday9 + totday10  + totday11
gen cumtd15= totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2 + totday3 + totday4  + totday5 + totday6 + totday7  + totday8 + totday9 + totday10  + totday11 + totday12 + totday13  + totday14
gen cumtd18= totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2 + totday3 + totday4  + totday5 + totday6 + totday7  + totday8 + totday9 + totday10  + totday11 + totday12 + totday13  + totday14 + totday15 + totday16  + totday17
gen cumtd21= totday_0 + totday_1 + totday_2 + totday_3 + totday1 + totday2 + totday3 + totday4  + totday5 + totday6 + totday7  + totday8 + totday9 + totday10  + totday11 + totday12 + totday13  + totday14 + totday15 + totday16  + totday17 + totday18 + totday19  + totday20

gen cumlab_ear3  = lab_ear3
gen cumlab_ear6  = lab_ear3 + lab_ear6
gen cumlab_ear9  = lab_ear3 + lab_ear6 + lab_ear9 
gen cumlab_ear12 = lab_ear3 + lab_ear6 + lab_ear9 + lab_ear12
gen cumlab_ear15 = lab_ear3 + lab_ear6 + lab_ear9 + lab_ear12 + lab_ear15
gen cumlab_ear18 = lab_ear3 + lab_ear6 + lab_ear9 + lab_ear12 + lab_ear15 + lab_ear18
gen cumlab_ear21 = lab_ear3 + lab_ear6 + lab_ear9 + lab_ear12 + lab_ear15 + lab_ear18 + lab_ear21

gen clab_ear3  = lab_ear1 + lab_ear2 + lab_ear3
gen clab_ear6  = clab_ear3  + lab_ear4  + lab_ear5  + lab_ear6
gen clab_ear9  = clab_ear6  + lab_ear7  + lab_ear8  + lab_ear9
gen clab_ear12 = clab_ear9  + lab_ear10 + lab_ear11 + lab_ear12
gen clab_ear15 = clab_ear12 + lab_ear13 + lab_ear14 + lab_ear15
gen clab_ear18 = clab_ear15 + lab_ear16 + lab_ear17 + lab_ear18
gen clab_ear21 = clab_ear18 + lab_ear19 + lab_ear20 + lab_ear21

drop eta inizio_periodo fine_periodo codente fondo tipo_contr unita_contr_diritto contr_diritto nascita /*
*/   unita_contr_misura contr_misura id_azienda qualifica tipo_durata tipo_orario source m_ini g_ini a_fin /*
*/   m_fin g_fin start end length rat leng_fte w t_len w_fte y rand totday_ft provnas103 provnas110 partime* spartime*
drop pb040 pb040_f pb090 pb100_f pb110_f pb120 pb120_f pb130_f pb140_f pb190 pb190_f pb200 pb200_f /*
*/   pe030_f pe040_f pl015 pl015_f pm005 pm005_f pm010 pm010_f pm020 pm020_f pm030 pm030_f pm035 pm035_f  /*
*/   pm040 pm040_f pm050 pm050_f pm060 pm060_f pm070 pm070_f pm080 pm080_f pm090 pm090_f pm100 pm100_f pt005 /*
*/   pt010 pt010_f pt020 pt020_f pt030 pt030_f pt040 pt040_f pt050 pt050_f pt060 pt060_f pt070 pt070_f pt080 /*
*/   pt080_f pt090 pt090_f pt100 pt100_f pt110 pt110_f pt120 pt120_f pt130 pt130_f pt140 pt140_f pt150 pt150_f /*
*/   pt160 pt160_f pt170 pt170_f pt180 pt180_f pt190 pt190_f pt200 pt200_f pt210 pt210_f
drop rb031_f rb050 rb050_f rb070 rb070_f rb080_f rb200 rb200_f rb210 rb210_f rb220_ rb220_f rb230_ rb230_f rb240_ /*
*/   rb240_f rb245 rb245_f rb250 rb250_f rb260 rb260_f rb270_ rb270_f
drop reg regione date_birth date_int date_edu reg1-reg20 aedu1-aedu20 dur1_lo dur1_up ageq1_lo ageq1_up complete w16-tdayft21 /*
*/ qual tiporaplav pub priv prof primo_anno ultimo_anno regr1 regr2 regr3 regr4 regr5 regr6 regr7 /*
*/ regr8 regr9 regr10 regr11 regr12 regr13 regr14 regr15 regr16 regr17 regr18 regr19 regr20 regr21 age3 age6 age9 age12 age15 age18 age21
drop priv* spriv* sid_* id_* squal* qual* pub* spub* fulltime

drop er1 er2 er4 er5 er7 er8 er10 er11 er13 er14 er16 er17 er19 er20 /*
*/ ur1 ur2 ur4 ur5 ur7 ur8 ur10 ur11 ur13 ur14 ur16 ur17 ur19 ur20 /*
*/ lab_ear1 lab_ear2 lab_ear4 lab_ear5 lab_ear7 lab_ear8 lab_ear10 lab_ear11 lab_ear13 lab_ear14 lab_ear16 lab_ear17 lab_ear19 lab_ear20 /*
*/ lab_wag1 lab_wag2 lab_wag4 lab_wag5 lab_wag7 lab_wag8 lab_wag10 lab_wag11 lab_wag13 lab_wag14 lab_wag16 lab_wag17 lab_wag19 lab_wag20 /*
*/ rgdp reg_res1 reg_res2 reg_res4 reg_res5 reg_res7 reg_res8 reg_res10 reg_res11 reg_res13 reg_res14 reg_res16 reg_res17 reg_res19 reg_res20 /*
*/ tfr1 tfr2 tfr4 tfr5 tfr7 tfr8 tfr10 tfr11 tfr13 tfr14 tfr16 tfr17 tfr19 tfr20 /*
*/ tot_inc1 tot_inc2 tot_inc4 tot_inc5 tot_inc7 tot_inc8 tot_inc10 tot_inc11 tot_inc13 tot_inc14 tot_inc16 tot_inc17 tot_inc19 tot_inc20 /*
*/ totday1 totday2 totday4 totday5 totday7 totday8 totday10 totday11 totday13 totday14 totday16 totday17 totday19 totday20 /*
*/ totday_ft1 totday_ft2 totday_ft4 totday_ft5 totday_ft7 totday_ft8 totday_ft10 totday_ft11 totday_ft13 totday_ft14 totday_ft16 totday_ft17 totday_ft19 totday_ft20 /*
*/ totday_pt1 totday_pt2 totday_pt4 totday_pt5 totday_pt7 totday_pt8 totday_pt10 totday_pt11 totday_pt13 totday_pt14 totday_pt16 totday_pt17 totday_pt19 totday_pt20
forvalues k = 1 (1) 21{
replace inps_anno`k'=. if inps_anno`k'>2011 & anno_silc==2011
replace inps_anno`k'=. if inps_anno`k'>2005 & anno_silc==2005
}

cap drop area5_nas
generate area5_nas=1 if (reg_nas>=1 & reg_nas<=3) | reg_nas==7
replace  area5_nas=2 if (reg_nas>=4 & reg_nas<=6) | reg_nas==8
replace  area5_nas=3 if reg_nas>=9 & reg_nas<=12
replace  area5_nas=4 if reg_nas>=13 & reg_nas<=18
replace  area5_nas=5 if reg_nas>=19 & reg_nas<=20
label variable area5_nas "Geographical area of birth"
label define area5 1 "North-West" 2 "North-East" 3 "Center" 4 "South" 5 "Islands"
label values area5_nas area5

replace er=er/100
replace ur=ur/100
forvalues k = 3 (3) 21 {
	replace er`k'=er`k'/100
	replace ur`k'=ur`k'/100
}
qui sum aedu
replace aedu=(aedu-r(min))/10
label variable aedu "Age/10 of diploma normalized to zero"

gen agemother=agedmo-13 if ybmoth_miss==0
qui sum agedmo if agedmo>0
replace agedmo=(agedmo-r(min)+1)/10 if agedmo>0
label variable aedu "Age of the mother at unit's birth/10, normalized to 1"

replace nsib_d05=nsib_d05/10
replace nsib_d11=nsib_d11/10

qui sum ybirth
replace ybirth=(ybirth-r(min))/10
label variable ybirth "Year of birth/10 normalized to zero"

replace lab_ear_1=lab_ear_1/1000
replace lab_ear_2=lab_ear_2/1000
replace lab_ear_3=lab_ear_3/1000

gen mhedu=0
replace mhedu=1 if medu3==1 | medu3==1
label variable mhedu "Mother has secondary or tertiary education"
aorder

forvalues k = 3 (3) 21 {
	replace er`k' =0 if er`k'==.
	replace ur`k' =0 if ur`k'==.
	replace tfr`k'=0 if tfr`k'==.
	replace lab_ear`k'=0 if lab_ear`k'==.
    replace lab_wag`k'=0 if lab_wag`k'==.
    replace totday`k'=0 if totday`k'==.
} 

********************************************************************************
cap drop k1
gen k1=0
forvalues k = 4 (1) 21 {
local j=`k'-1
replace k1=`k' if inps_anno`k'==. & inps_anno`j'!=. & num_kids_`k'==0
}
replace k1=22 if num_kids_21==0 & k1==0 /*For these women duration is larger than 21*/
cap drop cens1
gen cens1=0
replace cens1=1 if k1>0
label variable cens1 "=1 if no 1st kid before 21 years after diploma or SILC interview"
forvalues k = 1 (1) 21 {
replace k1=`k' if k1==0 & child1_`k'==1
}
bys cens1: tab k1

cap drop dur1
generate dur1=1 if k1>=0  & k1<=3  & cens1==0
replace  dur1=2 if k1>=4  & k1<=6  & cens1==0
replace  dur1=3 if k1>=7  & k1<=9  & cens1==0
replace  dur1=4 if k1>=10 & k1<=12 & cens1==0
replace  dur1=5 if k1>=13 & k1<=15 & cens1==0
replace  dur1=6 if k1>=16 & k1<=18 & cens1==0
replace  dur1=7 if k1>=19 & k1<=21 & cens1==0

replace  dur1=1 if k1>=4  & k1<=6  & cens1==1
replace  dur1=2 if k1>=7  & k1<=9  & cens1==1
replace  dur1=3 if k1>=10 & k1<=12 & cens1==1
replace  dur1=4 if k1>=13 & k1<=15 & cens1==1
replace  dur1=5 if k1>=16 & k1<=18 & cens1==1
replace  dur1=6 if k1>=19 & k1<=21 & cens1==1
replace  dur1=7 if k1==22          & cens1==1
label variable dur1 "duration in 3-years 1st kid (censored and uncensored)"
bys cens1: tab dur1

gen sam2=0
replace sam2=1 if cens1==0
label variable sam2 "=1 if woman had at least 1 kid before 21 years after diploma or SILC interview"
cap drop k2
gen k2=0
forvalues k = 4 (1) 21 {
local j=`k'-1
replace k2=`k' if inps_anno`k'==. & inps_anno`j'!=. & num_kids_`k'<2 & sam2==1
}
replace k2=22 if num_kids_21<2 & k2==0 & sam2==1 /*For these women duration is larger than 21*/

cap drop cens2
gen cens2=0
replace cens2=1 if k2>0 & sam2==1
label variable cens2 "=1 if no 2nd kid before 21 years after diploma or SILC interview"
forvalues k = 1 (1) 21 {
replace k2=`k' if k2==0 & child2_`k'==1
}
bys cens2: tab k2 if sam2==1

cap drop dur2
generate dur2=0
replace  dur2=1 if k2>=1  & k2<=6  & cens2==0 & sam2==1
replace  dur2=2 if k2>=7  & k2<=9  & cens2==0 & sam2==1
replace  dur2=3 if k2>=10 & k2<=12 & cens2==0 & sam2==1
replace  dur2=4 if k2>=13 & k2<=15 & cens2==0 & sam2==1
replace  dur2=5 if k2>=16 & k2<=18 & cens2==0 & sam2==1
replace  dur2=6 if k2>=19 & k2<=21 & cens2==0 & sam2==1

replace  dur2=1 if k2<=9  		   & cens2==1 & sam2==1
replace  dur2=2 if k2>=10 & k2<=12 & cens2==1 & sam2==1
replace  dur2=3 if k2>=13 & k2<=15 & cens2==1 & sam2==1
replace  dur2=4 if k2>=16 & k2<=18 & cens2==1 & sam2==1
replace  dur2=5 if k2>=19 & k2<=21 & cens2==1 & sam2==1
replace  dur2=6 if k2==22          & cens2==1 & sam2==1
label variable dur2 "duration in 3-years 2nd kid (censored and uncensored)"
bys cens2: tab dur2 if sam2==1
cap drop twins1
gen twins1=0
replace twins1=1 if k1==k2 & sam2==1

gen sam3=0
replace sam3=1 if cens2==0 & sam2==1
replace sam3=0 if sam2==1 & k1==k2/*This is to exclude women who had twins from modelling the 3rd pregnancy*/
label variable sam3 "=1 if woman had at least 3 kids before 21 years after diploma or SILC interview"
cap drop k3
gen k3=0
forvalues k = 4 (1) 21 {
local j=`k'-1
replace k3=`k' if inps_anno`k'==. & inps_anno`j'!=. & num_kids_`k'<3 & sam3==1
}
replace k3=22 if num_kids_21<3 & k3==0 & sam3==1 /*For these women duration is larger than 21*/

cap drop cens3
gen cens3=0
replace cens3=1 if k3>0 & sam3==1
label variable cens3 "=1 if no 3rd kid before 21 years after diploma or SILC interview"
forvalues k = 1 (1) 21 {
replace k3=`k' if k3==0 & child3_`k'==1
}
bys cens3: tab k3 if sam3==1

cap drop dur3
generate dur3=0
replace  dur3=1 if k3>=1  & k3<=12  & cens3==0 & sam3==1
replace  dur3=2 if k3>=13 & k3<=15  & cens3==0 & sam3==1
replace  dur3=3 if k3>=16 			& cens3==0 & sam3==1

replace  dur3=1 if k3<=15  		   & cens3==1 & sam3==1
replace  dur3=2 if k3>=16 & k3<=21 & cens3==1 & sam3==1
replace  dur3=3 if k3==22          & cens3==1 & sam3==1
label variable dur3 "duration in 3-years 3rd kid (censored and uncensored)"
bys cens3: tab dur3 if sam3==1
cap drop twins2
gen twins2=0
replace twins2=1 if k3==k2 & sam3==1
replace sam3=0 if k3==k2 & sam3==1 /*This is to exclude women who had twins in the 2nd pregnancy from modelling the birth of the 3rd kid*/

cap drop sex1
gen sex1=child_sex1-1
replace sex1=0 if sex1==.

replace k1=k1/10
replace k2=k2/10

cap drop sp12
gen sp12=k2-k1 if sam3==1
replace sp12=0 if sp12==.
cap drop samesex
gen samesex=0
replace samesex=1 if child_sex1==child_sex2 & sam3==1

drop num_kids_1 num_kids_2 num_kids_4 num_kids_5 num_kids_7 num_kids_8 num_kids_10 num_kids_11 num_kids_13 /*
*/ num_kids_14 num_kids_16 num_kids_17 num_kids_19 num_kids_20

*Depedent variable for ordered probit
tab dur1, gen(dur1_)

*Depedent variable for ordered probit
tab dur2 if sam2==1, gen(dur2_)
forvalues k = 1 (1) 6 {
replace dur2_`k'=0 if dur2_`k'==. 
}
*Depedent variable for ordered probit
tab dur3 if sam3==1, gen(dur3_)
forvalues k = 1 (1) 3 {
replace dur3_`k'=0 if dur3_`k'==.
}

********************************************************************
*The following dummies indicate the year intervals since the diploma in which the 1st, 2nd, and 3rd kids are born
********************************************************************
*** nascita primo figlio per periodi 13 46 79 1012 1315 1618 1921
gen kid1_13=0
replace kid1_13=1 if (child1_1==1 | child1_2==1 | child1_3==1)   
gen kid1_46=0
replace kid1_46=1 if (child1_4==1 | child1_5==1 | child1_6==1)   
gen kid1_79=0
replace kid1_79=1 if (child1_7==1 | child1_8==1 | child1_9==1)   
gen kid1_1012=0
replace kid1_1012=1 if (child1_10==1 | child1_11==1 | child1_12==1)   
gen kid1_1315=0
replace kid1_1315=1 if (child1_13==1 | child1_14==1 | child1_15==1)   
gen kid1_1618=0
replace kid1_1618=1 if (child1_16==1 | child1_17==1 | child1_18==1)   
gen kid1_1921=0
replace kid1_1921=1 if (child1_19==1 | child1_20==1 | child1_21==1)   
*** nascita secondo figlio per periodi 13 46 79 1012 1315 1618 1921
gen kid2_13=0
replace kid2_13=1 if (child2_1==1 | child2_2==1 | child2_3==1)
gen kid2_46=0
replace kid2_46=1 if (child2_4==1 | child2_5==1 | child2_6==1)
gen kid2_79=0 
replace kid2_79=1 if (child2_7==1 | child2_8==1 | child2_9==1)   
gen kid2_1012=0
replace kid2_1012=1 if (child2_10==1 | child2_11==1 | child2_12==1)   
gen kid2_1315=0
replace kid2_1315=1 if (child2_13==1 | child2_14==1 | child2_15==1)   
gen kid2_1618=0
replace kid2_1618=1 if (child2_16==1 | child2_17==1 | child2_18==1)   
gen kid2_1921=0
replace kid2_1921=1 if (child2_19==1 | child2_20==1 | child2_21==1)   
*** nascita terzo figlio per periodi 13 46 79 1012 1315 1618 1921
gen kid3_13=0
replace kid3_13=1 if (child3_1==1 | child3_2==1 | child3_3==1)
gen kid3_46=0
replace kid3_46=1 if (child3_4==1 | child3_5==1 | child3_6==1)  
gen kid3_79=0
replace kid3_79=1 if (child3_7==1 | child3_8==1 | child3_9==1)   
gen kid3_1012=0
replace kid3_1012=1 if (child3_10==1 | child3_11==1 | child3_12==1)   
gen kid3_1315=0
replace kid3_1315=1 if (child3_13==1 | child3_14==1 | child3_15==1)   
gen kid3_1618=0
replace kid3_1618=1 if (child3_16==1 | child3_17==1 | child3_18==1)   
gen kid3_1921=0
replace kid3_1921=1 if (child3_19==1 | child3_20==1 | child3_21==1)   


forvalues k = 3 (3) 21 {
cap drop area5_res`k'
generate area5_res`k'=1 if (reg_res`k'>=1 & reg_res`k'<=3) | reg_res`k'==7
replace  area5_res`k'=2 if (reg_res`k'>=4 & reg_res`k'<=6) | reg_res`k'==8
replace  area5_res`k'=3 if reg_res`k'>=9 & reg_res`k'<=12
replace  area5_res`k'=4 if reg_res`k'>=13 & reg_res`k'<=18
replace  area5_res`k'=5 if reg_res`k'>=19 & reg_res`k'<=20
label variable area5_res`k' "Geographical area of residence `k' years after diploma"
label values area5_res`k' area5
replace lab_ear`k'=lab_ear`k'/1000
}

forvalues k = 3 (3) 21 {
cap drop inps_5years`k'
gen inps_5years`k'=0
replace inps_5years`k'=1 if inps_anno`k'>=1980 & inps_anno`k'<=1985
replace inps_5years`k'=2 if inps_anno`k'> 1985 & inps_anno`k'<=1990
replace inps_5years`k'=3 if inps_anno`k'> 1990 & inps_anno`k'<=1995
replace inps_5years`k'=4 if inps_anno`k'> 1995 & inps_anno`k'<=2000
replace inps_5years`k'=5 if inps_anno`k'> 2000 & inps_anno`k'<=2005
replace inps_5years`k'=6 if inps_anno`k'> 2005 & inps_anno`k'<=2011
}


forvalues k = 3 (3) 21 {
global x`k' aedu edu2 edu3 totday_1 agedmo ybmoth_miss nsib_d05 nsib_d11 d11 mhedu memp qbir2 qbir3 qbir4 ybirth i.area5_res`k' ur`k' er`k' tfr`k' i.inps_5years`k'
}

global kid1_21 kid1_13 kid1_46 kid1_79 kid1_1012 kid1_1315 kid1_1618 kid1_1921
global kid2_21 kid2_13 kid2_46 kid2_79 kid2_1012 kid2_1315 kid2_1618 kid2_1921
global kid3_21 kid3_13 kid3_46 kid3_79 kid3_1012 kid3_1315 kid3_1618 kid3_1921
reg lab_ear21 $kid1_21 $kid2_21 $kid3_21 $x21, r
cap drop samw21
gen samw21=0
replace samw21=1 if e(sample)

global kid1_18 kid1_13 kid1_46 kid1_79 kid1_1012 kid1_1315 kid1_1618
global kid2_18 kid2_13 kid2_46 kid2_79 kid2_1012 kid2_1315 kid2_1618
global kid3_18 kid3_13 kid3_46 kid3_79 kid3_1012 kid3_1315 kid3_1618
reg lab_ear18 $kid1_18 $kid2_18 $kid3_18 $x18, r
cap drop samw18
gen samw18=0
replace samw18=1 if e(sample)

global kid1_15 kid1_13 kid1_46 kid1_79 kid1_1012 kid1_1315
global kid2_15 kid2_13 kid2_46 kid2_79 kid2_1012 kid2_1315
global kid3_15 kid3_13 kid3_46 kid3_79 kid3_1012 kid3_1315
reg lab_ear15 $kid1_15 $kid2_15 $kid3_15 $x15, r
cap drop samw15
gen samw15=0
replace samw15=1 if e(sample)

global kid1_12 kid1_13 kid1_46 kid1_79 kid1_1012
global kid2_12 kid2_13 kid2_46 kid2_79 kid2_1012
global kid3_12 kid3_13 kid3_46 kid3_79 kid3_1012
reg lab_ear12 $kid1_12 $kid2_12 $kid3_12 $x12, r
cap drop samw12
gen samw12=0
replace samw12=1 if e(sample)

global kid1_9 kid1_13 kid1_46 kid1_79 
global kid2_9 kid2_13 kid2_46 kid2_79 
global kid3_9 kid3_13 kid3_46 kid3_79 
reg lab_ear9 $kid1_9 $kid2_9 $kid3_9 $x9, r
cap drop samw9
gen samw9=0
replace samw9=1 if e(sample)

global kid1_6 kid1_13 kid1_46 
global kid2_6 kid2_13 kid2_46 
global kid3_6 kid3_13 kid3_46 
reg lab_ear6 $kid1_6 $kid2_6 $kid3_6 $x6, r
cap drop samw6
gen samw6=0
replace samw6=1 if e(sample)

cap drop timebirth1
cap drop timebirth2
cap drop timebirth3
gen timebirth1=.
gen timebirth2=.
gen timebirth3=.
forvalues k=1 (1) 21 {
replace timebirth1=`k' if child1_`k'==1 & cens1==0
replace timebirth2=`k' if child2_`k'==1 & cens2==0
replace timebirth3=`k' if child3_`k'==1 & cens3==0
}

hist timebirth1, bin(21) saving(f1.gph, replace) title("(a) Timing of 1st childbearing") xtitle("Years since school completion") ytitle("Density") graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
hist timebirth2, bin(20) saving(f2.gph, replace) title("(b) Timing of 2nd childbearing") xtitle("Years since school completion") ytitle("Density") graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
hist timebirth3, bin(17) saving(f3.gph, replace) title("(c) Timing of 3rd childbearing") xtitle("Years since school completion") ytitle("Density") graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
graph combine f1.gph f2.gph f3.gph, xcommon ycommon scale(1) graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) 
*graph export "fert_dens.eps", as(eps) logo(off) fontface(Times) replace
*graph export "fert_dens.pdf", as(pdf) logo(off) fontface(Times) replace

compress

drop timebirth3 timebirth2 timebirth1 pippo emp_1 Cod_reg agemother child_ybirth_9m1 child_ybirth_9m2 child_ybirth_9m3 year

order cumtd3 cumtd6 cumtd9 cumtd12 cumtd15 cumtd18 cumtd21 cumlab_ear3 cumlab_ear6 cumlab_ear9 cumlab_ear12 cumlab_ear15 cumlab_ear18 cumlab_ear21 clab_ear3 clab_ear6 clab_ear9 clab_ear12 clab_ear15 clab_ear18 clab_ear21, last

forvalues k = 3 (3) 21 {
replace clab_ear`k'=0 if clab_ear`k'==.
}

saveold "adsilc_pregnancy_3months.dta", replace version(11)
export sasxport "adsilc_pregnancy_3months.xpt", rename
